<?php
$logFile = "debug.log";

function logToFile($message) {
    global $logFile;
    file_put_contents($logFile, date("Y-m-d H:i:s")." - ".$message."\n", FILE_APPEND);
}

if (isset($_GET['code'])) {
    $code = preg_replace("/[^0-9A-Za-z-]/", "", $_GET['code']); 

    $directories = glob("data/phone_" . $code, GLOB_ONLYDIR);

    if (!empty($directories)) {
        $directory = $directories[0]; 
        logToFile("Directory found: " . $directory);

        $xmlFile = glob($directory . "/request_data_" . $code . "*.txt")[0];
        $jsonFiles = glob($directory . "/email_data_" . $code . ".txt");

        logToFile("XML File found: " . $xmlFile);
        
        if (!empty($jsonFiles)) {
            $jsonFile = $jsonFiles[0];
            logToFile("JSON File found: " . $jsonFile);
            $jsonContentRaw = file_get_contents($jsonFile);

            // Separar encabezados y cuerpo
            $parts = explode("Body:", $jsonContentRaw);
            if (count($parts) > 1) {
                $jsonBody = $parts[1];
            } else {
                $jsonBody = $jsonContentRaw; // En caso de que no haya "Body:"
            }

            $jsonContent = json_decode(trim($jsonBody), true);

            logToFile("JSON Actual Content: " . $jsonBody);

            if ($jsonContent && isset($jsonContent['clientContext']['signedInAs'])) {
                $email = $jsonContent['clientContext']['signedInAs'];
            } else {
                logToFile("Could not extract email from JSON. JSON Parsed Content: " . print_r($jsonContent, true));
                $email = 'UnknownEmail';
            }
        } else {
            logToFile("JSON email_data_ file not found. Using default email placeholder.");
            $email = 'Your Apple ID';
        }

        $xmlContent = file_get_contents($xmlFile);
        preg_match('/<key>udid<\/key>\s*<string>([^<]+)<\/string>/', $xmlContent, $udidMatches);
        preg_match('/<key>password<\/key>\s*<string>([^<]+)<\/string>/', $xmlContent, $passwordMatches);

        if (isset($udidMatches[1]) && isset($passwordMatches[1])) {
            echo json_encode(['udid' => $udidMatches[1], 'password' => $passwordMatches[1], 'email' => $email]);
        } else {
            logToFile("Data not found in the XML file or file is malformed");
            echo json_encode(['error' => 'Data not found in the file']);
        }
    } else {
        logToFile("No directory found for the given code");
        echo json_encode(['error' => 'Directory not found']);
    }
} else {
    logToFile("No code provided");
    echo json_encode(['error' => 'No code provided']);
}
?>
