<?php

    function authSignin($account, $password) {
        // JSON de datos de login
        $loginData = json_encode([
            "accountName" => $account,
            "password" => $password,
            "rememberMe" => true,
            "trustTokens" => [],
            "pause2FA" => true
        ]);

        // URL de autenticación
        $url = "https://idmsa.apple.com/appleauth/auth/signin";

        // Encabezados HTTP
        $headers = [
            "Accept: */*",
            "Content-Type: application/json",
            "X-Apple-OAuth-Client-Id: d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d",
            "X-Apple-OAuth-Client-Type: firstPartyAuth",
            "X-Apple-OAuth-Redirect-URI: https://www.icloud.com",
            "X-Apple-OAuth-Require-Grant-Code: true",
            "X-Apple-OAuth-Response-Mode: web_message",
            "X-Apple-OAuth-Response-Type: code",
            "X-Apple-Widget-Key: d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d",
            "User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/603.3.1 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.1"
        ];

        // Realizar la petición POST con curl
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $loginData);
        curl_setopt($ch, CURLOPT_HEADER, true);

        $response = curl_exec($ch);
        curl_close($ch);

        // Extraer X-Apple-Session-Token del header
        if (preg_match('/X-Apple-Session-Token: (.+)/', $response, $matches)) {
            $session_token = trim($matches[1]);
            return $session_token;
        } else {
            // Si no se encuentra el token, devolver null
            return null;
        }
    }



    function SetupiCloudAccountLogin($dsWebAuthToken, $dirAppleAccount) {
        $url = "https://setup.icloud.com/setup/ws/1/accountLogin";
        $data = json_encode([
            "dsWebAuthToken" => $dsWebAuthToken,
            "accountCountryCode" => "MEX"
        ]);

        // Encabezados HTTP
        $headers = [
            'Host: setup.icloud.com',
            'Connection: keep-alive',
            'sec-ch-ua: "Not_A Brand";v="8", "Chromium";v="120", "Microsoft Edge";v="120"',
            'sec-ch-ua-platform: "Windows"',
            'sec-ch-ua-mobile: ?0',
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0',
            'Content-Type: text/plain;charset=UTF-8',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: gzip, deflate, br',
            'Accept-Language: es,es-ES;q=0.9,en;q=0.8,en-GB;q=0.7,en-US;q=0.6'
        ];

        // Realizar la solicitud POST con curl
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        $response1 = gzdecode(curl_exec($ch));
        curl_setopt($ch, CURLOPT_HEADER, true);
        $response = curl_exec($ch);
        file_put_contents($dirAppleAccount . '/checkpoint', $response1);

        curl_close($ch);

        // Extraer cookies y el cuerpo de la respuesta
        preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $response, $matches);
        $cookies = implode("; ", $matches[1]);

        preg_match('/\r\n\r\n(.*)/', $response, $matches);
        $response_body = $matches[1];

        $response_data = json_decode($response1, true);
        $server = $response_data['webservices']['findme']['url'] ?? null;
        $error = $response_data['error'] ?? null;

        // Guardar cookies en un archivo
        file_put_contents($dirAppleAccount . '/cookies', $cookies);


        if ($error !== null) {
        echo "Error: $error";
        } else {
        file_put_contents($dirAppleAccount . '/servercookies', "Server: $server\nCookies: $cookies");
        }
    }

    function getdevices($cookies, $dirAppleAccount) {
        $url = "https://p38-setup.icloud.com/setup/web/device/getDevices";

        // Encabezados HTTP
        $headers = [
            "Host: p38-setup.icloud.com",
            "Connection: keep-alive",
            'sec-ch-ua: "Not/A)Brand";v="8", "Chromium";v="126", "Google Chrome";v="126"',
            'sec-ch-ua-platform: "Windows"',
            'sec-ch-ua-mobile: ?0',
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36',
            'Content-Type: text/plain',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: gzip, deflate, br', // Aceptar respuesta comprimida
            'Accept-Language: es-419,es;q=0.9',
            "Cookie: $cookies"
        ];

        // Datos a enviar
        $data = json_encode([
            "serverContext" => [
                "minCallbackIntervalInMS" => 5000,
                "pendingRemoveGracePeriodInDays" => 30,
                "enable2FAFamilyActions" => false,
                "preferredLanguage" => "es-mx",
                "lastSessionExtensionTime" => null,
                "validRegion" => true,
                "enableMapStats" => true,
                "callbackIntervalInMS" => 10000,
                "timezone" => [
                    "currentOffset" => -25200000,
                    "previousTransition" => 1710064799999,
                    "previousOffset" => -28800000,
                    "tzCurrentName" => "Pacific Daylight Time",
                    "tzName" => "US/Pacific"
                ],
                "authToken" => null,
                "maxCallbackIntervalInMS" => 60000,
                "classicUser" => false,
                "isHSA" => true,
                "trackInfoCacheDurationInSecs" => 86400,
                "imageBaseUrl" => "https://statici.icloud.com",
                "minTrackLocThresholdInMts" => 100,
                "itemLearnMoreURL" => "https://support.apple.com/kb/HT211331?viewlocale=es_MX",
                "maxLocatingTime" => 90000,
                "itemsTabEnabled" => true,
                "sessionLifespan" => 900000,
                "info" => "AXspeP+oQjbOEjLk3a3WFZj300w01/4gkyfVqqVlEOosnk8uKX10X7cDlbgKxfbXeLF136raSp59p4sHpN2GyBdmJFo2xKRu0LGaLtnm",
                "prefsUpdateTime" => 1715297856541,
                "useAuthWidget" => true,
                "inaccuracyRadiusThreshold" => 200,
                "clientId" => "Y2xpZW50XzIxNTg3MjgyMDM5XzE3MjEyMzgyNTIyNTU=",
                "enable2FAFamilyRemove" => false,
                "serverTimestamp" => 1721238490669,
                "deviceImageVersion" => "30",
                "macCount" => 0,
                "deviceLoadStatus" => "200",
                "maxDeviceLoadTime" => 60000,
                "prsId" => 21587282039,
                "showSllNow" => false,
                "cloudUser" => true,
                "enable2FAErase" => false,
                "id" => "server_ctx"
            ],
            "clientContext" => [
                "appName" => "iCloud Find (Web)",
                "appVersion" => "2.0",
                "apiVersion" => "3.0",
                "deviceListVersion" => 1,
                "fmly" => true,
                "timezone" => "US/Pacific",
                "inactiveTime" => 36739
            ]
        ]);

        // Guardar la solicitud enviada (headers y data)
        file_put_contents($dirAppleAccount . '/device_request.json', "Headers: " . print_r($headers, true) . "\nData: " . $data . "\n\n", FILE_APPEND);

        // Realizar la solicitud POST
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip,deflate'); // Configurar CURL para manejar la descompresión
        $response = curl_exec($ch);
        curl_close($ch);

            // Guardar la respuesta en un archivo
            // Decodificar la respuesta JSON para convertirla en un array o un objeto PHP
            $decodedResponse = json_decode($response, true);

            // Verificar si la decodificación fue exitosa
            if (json_last_error() === JSON_ERROR_NONE) {
                // Volver a codificar el JSON con formato legible (pretty print)
                $prettyJsonResponse = json_encode($decodedResponse, JSON_PRETTY_PRINT);

                // Guardar el JSON formateado en el archivo
                file_put_contents($dirAppleAccount . '/device_response.json', $prettyJsonResponse . PHP_EOL, FILE_APPEND);
            } else {
                // En caso de error, puedes registrar el error o manejarlo de otra manera
                file_put_contents($dirAppleAccount . '/device_response.json', "Error al decodificar el JSON: " . json_last_error_msg() . PHP_EOL, FILE_APPEND);
            }

        // Decodificar la respuesta JSON
        $response = json_decode($response, true);

        // Si hay un error al decodificar, guardarlo en un archivo
        if (json_last_error() !== JSON_ERROR_NONE) {
            file_put_contents($dirAppleAccount . '/device_json_error.json', json_last_error_msg(), FILE_APPEND);
            return null;
        }

        // Retornar los dispositivos
        return $response['devices'] ?? null;
    }



    function refreshClient($server, $cookies, $dirAppleAccount) {
        $server2 = str_replace(['https://', ':443'], '', $server);

        // Encabezados HTTP
        $headers = [
            "Host: $server2",
            "Connection: keep-alive",
            'sec-ch-ua: "Not/A)Brand";v="8", "Chromium";v="126", "Google Chrome";v="126"',
            'sec-ch-ua-platform: "Windows"',
            'sec-ch-ua-mobile: ?0',
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36',
            'Content-Type: text/plain',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: gzip, deflate, br, zstd',
            'Accept-Language: es-419,es;q=0.9',
            "Cookie: $cookies"
        ];

        // Datos a enviar
        $data = json_encode([
            "serverContext" => [
                "minCallbackIntervalInMS" => 5000,
                "pendingRemoveGracePeriodInDays" => 30,
                "enable2FAFamilyActions" => false,
                "preferredLanguage" => "es-mx",
                "lastSessionExtensionTime" => null,
                "validRegion" => true,
                "enableMapStats" => true,
                "callbackIntervalInMS" => 10000,
                "timezone" => [
                    "currentOffset" => -25200000,
                    "previousTransition" => 1710064799999,
                    "previousOffset" => -28800000,
                    "tzCurrentName" => "Pacific Daylight Time",
                    "tzName" => "US/Pacific"
                ],
                "authToken" => null,
                "maxCallbackIntervalInMS" => 60000,
                "classicUser" => false,
                "isHSA" => true,
                "trackInfoCacheDurationInSecs" => 86400,
                "imageBaseUrl" => "https://statici.icloud.com",
                "minTrackLocThresholdInMts" => 100,
                "itemLearnMoreURL" => "https://support.apple.com/kb/HT211331?viewlocale=es_MX",
                "maxLocatingTime" => 90000,
                "itemsTabEnabled" => true,
                "sessionLifespan" => 900000,
                "info" => "AXspeP+oQjbOEjLk3a3WFZj300w01/4gkyfVqqVlEOosnk8uKX10X7cDlbgKxfbXeLF136raSp59p4sHpN2GyBdmJFo2xKRu0LGaLtnm",
                "prefsUpdateTime" => 1715297856541,
                "useAuthWidget" => true,
                "inaccuracyRadiusThreshold" => 200,
                "clientId" => "Y2xpZW50XzIxNTg3MjgyMDM5XzE3MjEyMzgyNTIyNTU=",
                "enable2FAFamilyRemove" => false,
                "serverTimestamp" => 1721238490669,
                "deviceImageVersion" => "30",
                "macCount" => 0,
                "deviceLoadStatus" => "200",
                "maxDeviceLoadTime" => 60000,
                "prsId" => 21587282039,
                "showSllNow" => false,
                "cloudUser" => true,
                "enable2FAErase" => false,
                "id" => "server_ctx"
            ],
            "clientContext" => [
                "appName" => "iCloud Find (Web)",
                "appVersion" => "2.0",
                "apiVersion" => "3.0",
                "deviceListVersion" => 1,
                "fmly" => true,
                "timezone" => "US/Pacific",
                "inactiveTime" => 36739
            ]
        ]);

        $complete_url = "$server/fmipservice/client/web/refreshClient";

        // Realizar la solicitud POST
        $ch = curl_init($complete_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        $responseOnly = curl_exec($ch);
        curl_setopt($ch, CURLOPT_HEADER, true);

        $responseWithHeaders = curl_exec($ch);
        curl_close($ch);

        // Guardar la respuesta completa
        file_put_contents($dirAppleAccount . '/responseWithHeaders.txt', $responseWithHeaders);

        // Extraer y guardar las cookies nuevas
        preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $responseWithHeaders, $matches);
        $new_cookies = implode("; ", $matches[1]);
        file_put_contents($dirAppleAccount . '/new_cookies.txt', $new_cookies);

        file_put_contents($dirAppleAccount . '/getDetails.json', $responseOnly);

        $devices = getdevices($cookies, $dirAppleAccount);

    }


    function authLogin($server, $info, $clientId, $deviceId, $password, $authToken, $dirAppleAccount) {
        // Crear o sobrescribir el archivo de log al inicio de la función
        $logFile = $dirAppleAccount . '/auth_login_data_send.log';
        file_put_contents($logFile, "Iniciando el proceso authLogin...\n");

        $cookies = file_get_contents($dirAppleAccount . "/CookiesFinales");
        $server2 = str_replace(['https://', ':443'], '', $server);

        // Loguear los valores de las variables $ que se utilizan
        file_put_contents($logFile, "server: $server\n", FILE_APPEND);
        file_put_contents($logFile, "info: $info\n", FILE_APPEND);
        file_put_contents($logFile, "clientId: $clientId\n", FILE_APPEND);
        file_put_contents($logFile, "deviceId: $deviceId\n", FILE_APPEND);
        file_put_contents($logFile, "password: $password\n", FILE_APPEND);
        file_put_contents($logFile, "authToken: $authToken\n", FILE_APPEND);
        file_put_contents($logFile, "dirAppleAccount: $dirAppleAccount\n", FILE_APPEND);
        file_put_contents($logFile, "cookies: $cookies\n", FILE_APPEND);
        file_put_contents($logFile, "server2: $server2\n", FILE_APPEND);

        $url = "$server/fmipservice/client/web/authForUserDevice?clientBuildNumber=2404Project45&clientMasteringNumber=2404B20&clientId=9961bff9-8211-43bb-b4c7-c0794a9ac791&dsid=20147186009";

        // Preparar el cuerpo de la solicitud
        $body = json_encode([
            "serverContext" => [
                "minCallbackIntervalInMS" => 5000,
                "pendingRemoveGracePeriodInDays" => 30,
                "enable2FAFamilyActions" => false,
                "preferredLanguage" => "es-mx",
                "lastSessionExtensionTime" => null,
                "validRegion" => true,
                "callbackIntervalInMS" => 30000,
                "enableMapStats" => true,
                "timezone" => [
                    "currentOffset" => -28800000,
                    "previousTransition" => 1699174799999,
                    "previousOffset" => -25200000,
                    "tzCurrentName" => "Pacific Standard Time",
                    "tzName" => "US/Pacific"
                ],
                "authToken" => $authToken,
                "maxCallbackIntervalInMS" => 60000,
                "classicUser" => false,
                "isHSA" => true,
                "trackInfoCacheDurationInSecs" => 86400,
                "imageBaseUrl" => "https://statici.icloud.com",
                "minTrackLocThresholdInMts" => 100,
                "itemLearnMoreURL" => "https://support.apple.com/kb/HT211331?viewlocale=es_MX",
                "maxLocatingTime" => 90000,
                "itemsTabEnabled" => true,
                "sessionLifespan" => 900000,
                "info" => $info,
                "prefsUpdateTime" => 1701935090984,
                "useAuthWidget" => true,
                "inaccuracyRadiusThreshold" => 200,
                "clientId" => $clientId,
                "enable2FAFamilyRemove" => false,
                "serverTimestamp" => 1702225130545,
                "deviceImageVersion" => "28",
                "macCount" => 0,
                "deviceLoadStatus" => "200",
                "maxDeviceLoadTime" => 60000,
                "prsId" => 20147186009,
                "showSllNow" => false,
                "cloudUser" => true,
                "enable2FAErase" => false,
                "id" => "server_ctx"
            ],
            "clientContext" => [
                "appName" => "iCloud Find (Web)",
                "appVersion" => "2.0",
                "apiVersion" => "3.0",
                "deviceListVersion" => 1,
                "fmly" => true,
                "timezone" => "US/Pacific",
                "inactiveTime" => 1899
            ],
            "device" => $deviceId,
            "authToken" => $password
        ]);

        // Loguear la URL y el cuerpo de la solicitud
        file_put_contents($logFile, "URL: $url\n", FILE_APPEND);
        file_put_contents($logFile, "Cuerpo de la solicitud: $body\n", FILE_APPEND);

        // Preparar los encabezados
        $headers = [
            "Host: $server2",
            "Connection: keep-alive",
            'sec-ch-ua: "Not_A Brand";v="8", "Chromium";v="120", "Microsoft Edge";v="120"',
            'sec-ch-ua-platform: "Windows"',
            'sec-ch-ua-mobile: ?0',
            'Content-Type: text/plain',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: ',
            'Accept-Language: es,es-ES;q=0.9,en;q=0.8,en-GB;q=0.7,en-US;q=0.6',
            "Cookie: $cookies"
        ];

        // Loguear los encabezados
        file_put_contents($logFile, "Encabezados: " . print_r($headers, true) . "\n", FILE_APPEND);

        // Ejecutar la solicitud POST con curl
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);

        $response = curl_exec($ch);
        curl_close($ch);

        // Loguear la respuesta
        file_put_contents($logFile, "Respuesta: $response\n", FILE_APPEND);

        // Decodificar la respuesta JSON y extraer authToken
        $response_data = json_decode($response, true);
        $authToken = $response_data['authToken'] ?? null;

        return $authToken;
    }



    function Remove($Servers, $Info, $ClientID, $authToken, $deviceID, $prsId, $dirAppleAccount) {
        // Log file path
        $logFilePath = $dirAppleAccount . '/remove_data_send.log';

        // Create or clear the log file at the start of each operation
        file_put_contents($logFilePath, "");

        // Log data entry
        file_put_contents($logFilePath, "Starting Remove operation\n", FILE_APPEND);

        $Cookies = file_get_contents($dirAppleAccount . "/CookiesFinales");
        $Server = str_replace(":443", "", $Servers);
        $Server2 = str_replace("https://", "", $Server);

        $url = $Server."/fmipservice/client/web/remove?clientBuildNumber=2404Project45&clientMasteringNumber=2404B20&clientId=9961bff9-8211-43bb-b4c7-c0794a9ac791&dsid=20147186009";
        $Headers = array(
            'Host: '.$Server2,
            'Connection: keep-alive',
            'sec-ch-ua: "Not_A Brand";v="8", "Chromium";v="120", "Microsoft Edge";v="120"',
            'sec-ch-ua-platform: "Windows"',
            'sec-ch-ua-mobile: ?0',
            'Content-Type: text/plain',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: gzip, deflate, br',
            'Accept-Language: es,es-ES;q=0.9,en;q=0.8,en-GB;q=0.7,en-US;q=0.6',
            'Cookie: '.$Cookies
        );

        $Body = '{
          "serverContext": {
            "minCallbackIntervalInMS": 5000,
            "pendingRemoveGracePeriodInDays": 30,
            "enable2FAFamilyActions": false,
            "preferredLanguage": "es-mx",
            "lastSessionExtensionTime": null,
            "validRegion": true,
            "callbackIntervalInMS": 30000,
            "enableMapStats": true,
            "timezone": {
              "currentOffset": -28800000,
              "previousTransition": 1699174799999,
              "previousOffset": -25200000,
              "tzCurrentName": "Pacific Standard Time",
              "tzName": "US/Pacific"
            },
            "authToken": null,
            "maxCallbackIntervalInMS": 60000,
            "classicUser": false,
            "isHSA": true,
            "trackInfoCacheDurationInSecs": 86400,
            "imageBaseUrl": "https://statici.icloud.com",
            "minTrackLocThresholdInMts": 100,
            "itemLearnMoreURL": "https://support.apple.com/kb/HT211331?viewlocale=es,es-es;q=0.9,en;q=0.8,en-gb;q=0.7,en-us;q=0.6",
            "maxLocatingTime": 90000,
            "itemsTabEnabled": true,
            "sessionLifespan": 900000,
            "info": "'.$Info.'",
            "prefsUpdateTime": 1701935090984,
            "useAuthWidget": true,
            "inaccuracyRadiusThreshold": 200,
            "clientId": "'.$ClientID.'",
            "enable2FAFamilyRemove": false,
            "serverTimestamp": 1702225130545,
            "deviceImageVersion": "28",
            "macCount": 0,
            "deviceLoadStatus": "200",
            "maxDeviceLoadTime": 60000,
            "prsId": '.$prsId.',
            "showSllNow": false,
            "cloudUser": true,
            "enable2FAErase": false,
            "id": "server_ctx"
          },
          "clientContext": {
            "appName": "iCloud Find (Web)",
            "appVersion": "2.0",
            "apiVersion": "3.0",
            "deviceListVersion": 1,
            "fmly": true,
            "timezone": "US/Pacific",
            "inactiveTime": 2315
          },
          "device": "'.$deviceID.'",
          "authToken": '.$authToken.'
        }';

        // Log headers, request body, and dynamic data before sending the request
        file_put_contents($logFilePath, "Headers: \n" . print_r($Headers, true) . "\n", FILE_APPEND);
        file_put_contents($logFilePath, "Request Body: \n" . $Body . "\n", FILE_APPEND);

        // Log each dynamic variable separately for clarity
        $logData = [
            'Server' => $Server,
            'Server2' => $Server2,
            'ClientID' => $ClientID,
            'Info' => $Info,
            'DeviceID' => $deviceID,
            'AuthToken' => $authToken,
            'PrsId' => $prsId
        ];

        foreach ($logData as $key => $value) {
            file_put_contents($logFilePath, "$key: $value\n", FILE_APPEND);
        }

        $ch = curl_init(); 
        curl_setopt($ch, CURLOPT_URL , $url); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER , true); 
        curl_setopt($ch, CURLOPT_TIMEOUT , 60); 
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $Headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_USERAGENT , "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0" );
        curl_setopt($ch, CURLOPT_POST , true); 
        curl_setopt($ch, CURLOPT_POSTFIELDS , $Body);
        $xml_response = curl_exec($ch); 
        curl_close($ch);

        // Log the response
        file_put_contents($logFilePath, "Response: \n" . $xml_response . "\n", FILE_APPEND);

        $Decoded = json_decode($xml_response, true);
        $Check = $Decoded["statusCode"];   

        // Log the result of the operation
        if($Check == "200"){
            file_put_contents($logFilePath, "Operation Result: SUCCESS\n", FILE_APPEND);
            return "SUCCESS";
        } else {
            file_put_contents($logFilePath, "Operation Result: FAILED\n", FILE_APPEND);
        }
    }


//////////////////////////////////////////////////////////////////////////////////////////

// Definir variables globales para las credenciales
global $AppleIDS;
global $ApplepasswordS;
global $dirAppleAccount;

// Función para obtener datos de POST o GET
function getRequestParam($key) {
    return isset($_POST[$key]) ? $_POST[$key] : (isset($_GET[$key]) ? $_GET[$key] : null);
}

// Obtener parámetros de usuario y contraseña
$user = getRequestParam('user');
$pass = getRequestParam('pass');

// Verificar que los parámetros necesarios estén presentes
if (!$user || !$pass) {
    die("User or password missing.");
}

// Asignar las credenciales a las variables globales
$AppleIDS = $user;
$ApplepasswordS = $pass;

// Crear o actualizar el directorio basado en $AppleIDS
$dirAppleAccount = __DIR__ . '/remove/' . $AppleIDS;
$DevicesAppleFolder = $dirAppleAccount . '/Devices/';

// Verificar si el directorio ya existe
if (is_dir($dirAppleAccount)) {
    // Eliminar el contenido del directorio y el subdirectorio Devices
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($dirAppleAccount, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::CHILD_FIRST
    );

    foreach ($files as $fileinfo) {
        $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
        $todo($fileinfo->getRealPath());
    }

    // Eliminar el directorio principal
    rmdir($dirAppleAccount);
}

// Crear el nuevo directorio y el subdirectorio "Devices"
if (!mkdir($dirAppleAccount, 0777, true)) {
    die("Error creating directory: $dirAppleAccount");
}

if (!mkdir($DevicesAppleFolder, 0777, true)) {
    die("Error creating Devices subdirectory: $DevicesAppleFolder");
}

// Iniciar sesión y configurar la cuenta de iCloud
$AuthToken = authSignin($AppleIDS, $ApplepasswordS);

if (!$AuthToken) {
    // Manejar el caso donde las credenciales son incorrectas
    echo "El Apple ID o la contraseña son incorrectos.";
    exit();
}


SetupiCloudAccountLogin($AuthToken, $dirAppleAccount);

// Obtener el servidor y las cookies desde un archivo
$server_and_cookies = file_get_contents($dirAppleAccount . "/servercookies");
preg_match('/Server: (.+)/', $server_and_cookies, $server_matches);
$server = trim($server_matches[1]);
preg_match('/Cookies: (.+)/', $server_and_cookies, $cookies_matches);
$cookies = trim($cookies_matches[1]);

// Actualizar el cliente con los datos obtenidos
refreshClient($server, $cookies, $dirAppleAccount);

// Preparar el archivo con los detalles del dispositivo
$getDetails = $dirAppleAccount . "/getDetails.json";
$getmoreDetails = $dirAppleAccount . "/device_response.json";
$Galletas = file_get_contents($dirAppleAccount . "/new_cookies.txt");
file_put_contents($dirAppleAccount . '/CookiesFinales', $cookies . $Galletas);

// Usar json_decode para extraer información del contexto del servidor
$details = json_decode(file_get_contents($getDetails), true);
$detailsmore = json_decode(file_get_contents($getmoreDetails), true);


if ($details === null) {
    die("Error parsing JSON file.");
}

$info = $details['serverContext']['info'] ?? 'N/A';
$clientId = $details['serverContext']['clientId'] ?? 'N/A';
$prsId = $details['serverContext']['prsId'] ?? 'N/A';


// Leer el contenido del archivo responseWithHeaders.txt
$responseFilePath = $dirAppleAccount . '/responseWithHeaders.txt';
$responseContent = file_get_contents($responseFilePath);

// Verificar si el contenido se leyó correctamente
if ($responseContent === false) {
    echo "Error al leer el archivo: $responseFilePath\n";
    exit;
}

// Buscar el valor de X-APPLE-WEBAUTH-FMIP en el contenido
preg_match('/Set-Cookie: X-APPLE-WEBAUTH-FMIP="([^"]+)"/', $responseContent, $matches);

// Verificar si se encontró el token
if (isset($matches[1])) {
    $authTokensss = $matches[1];
} else {
    
}



$content = $details['content'] ?? [];
$contentmore = $detailsmore['devices'] ?? [];

// Verificar que se hayan obtenido detalles del dispositivo
if (!empty($content)) {
    // Verificar si el directorio 'Devices' ya existe y eliminarlo si es necesario
    if (is_dir('Devices')) {
        // Eliminar el directorio y su contenido
        array_map('unlink', glob("Devices/*.*"));
        rmdir('Devices');
    }

    // Crear un nuevo directorio para almacenar la información de los dispositivos
    mkdir('Devices', 0777, true);

    foreach ($content as $index => $device) {
        $id = $device['id'] ?? 'N/A';
        $NameModel = $device['modelDisplayName'] ?? 'N/A';
        $Name = $device['name'] ?? 'N/A';
        $Battery = $device['batteryStatus'] ?? 'N/A';
        $Batt = $Battery ? "$Battery" : 'N/A';
        $DeviceStatus = $device['deviceStatus'] ?? 'N/A';
        $ProductType = $device['rawDeviceModel'] ?? 'N/A';
        $Lost = isset($device['lostModeEnabled']) ? ($device['lostModeEnabled'] ? "YES" : "NO") : 'N/A';

        // Obtener detalles adicionales del dispositivo de $contentmore usando modelDisplayName
        $moreDetails = [];
        foreach ($contentmore as $moreDevice) {
            if ($moreDevice['modelDisplayName'] == $device['deviceDisplayName']) {
                $moreDetails = $moreDevice;
                break;
            }
        }


        $serialNumber = $moreDetails['serialNumber'] ?? 'N/A';
        $imei = $moreDetails['imei'] ?? 'N/A';
        $latestBackup = $moreDetails['latestBackup'] ?? 'N/A';
        $modelLargePhotoURL2x = $moreDetails['modelLargePhotoURL2x'] ?? 'N/A';

        // Obtener el token de autenticación
        $authToken = authLogin($server, $info, $clientId, $id, $ApplepasswordS, $authTokensss, $dirAppleAccount);
        if ($authToken == null) {
            $authToken = "null";
        } else {
            $authToken = "\"$authToken\"";
        }

        // Preparar los datos utilizados en la llamada a authLogin y el resultado del token
        $authLogData = [
            'server' => $server,
            'info' => $info,
            'clientId' => $clientId,
            'id' => $id,
            'user' => "S3278548@s", // Este es el usuario utilizado en la función
            'authTokensss' => $authTokensss,
            'dirAppleAccount' => $dirAppleAccount,
            'authToken' => $authToken,
            'timestamp' => date('Y-m-d H:i:s')
        ];

        // Convertir los datos a un formato legible (por ejemplo, JSON)
        $authLogEntry = json_encode($authLogData, JSON_PRETTY_PRINT);

        // Guardar los datos en form_remove.log
        file_put_contents($dirAppleAccount . '/form_remove.log', $authLogEntry . PHP_EOL, FILE_APPEND);

        // Continuar con el resto del código
        $RemoveDevice = Remove($server, $info, $clientId, $authToken, $id, $prsId, $dirAppleAccount);

        file_put_contents($dirAppleAccount . "/$NameModel.txt", "RemoveDevice response: $RemoveDevice");

        $Status = !empty($RemoveDevice) ? "SUCCESS ✅" : "ERROR ❌";

        // Determinar el estado usando statusCode del dispositivo
        $statusCode = $device['statusCode'] ?? 'N/A';
        $StatusFMI = ($statusCode === "200") ? "FMI OFF" : "FMI ON";

        // Reemplazar caracteres Unicode específicos en la salida
        $ActivationLocked = $device['activationLocked'] ? "YES" : "NO";
        $LocationEnabled = $device['locationEnabled'] ? "YES" : "NO";
        $LowPowerMode = $device['lowPowerMode'] ? "YES" : "NO";
        $DeviceWithYou = $device['deviceWithYou'] ? "YES" : "NO";
        $IsLocating = $device['isLocating'] ? "YES" : "NO";

        // Preparar la salida del dispositivo combinando detalles de $content y $contentmore
        $output = [
            "firstName" => $details['userInfo']['firstName'] ?? 'N/A',
            "lastName" => $details['userInfo']['lastName'] ?? 'N/A',
            "FMI" => ($details['statusCode'] ?? 'N/A') === '200' ? 'FMI OFF' : 'FMI ON',
            "StatusFMI" => $Status,
            "Device Display Name" => $device['deviceDisplayName'] ?? 'N/A',
            "Model" => $NameModel,
            "Name" => $Name,
            "Battery" => $Batt,
            "Status" => $DeviceStatus,
            "Product" => $ProductType,
            "Lost" => $Lost,
            "Msg Lost" => $device['mesg'] ?? 'N/A',
            "Activation Locked" => $ActivationLocked,
            "Passcode Length" => $device['passcodeLength'] ?? 'N/A',
            "Location Enabled" => $LocationEnabled,
            "Low Power Mode" => $LowPowerMode,
            "Device Color" => $device['deviceColor'] ?? 'N/A',
            "Device Model" => $device['deviceModel'] ?? 'N/A',
            "Raw Device Model" => $device['rawDeviceModel'] ?? 'N/A',
            "Device Discovery ID" => $device['deviceDiscoveryId'] ?? 'N/A',
            "Lost Timestamp" => $device['lostTimestamp'] ?? 'N/A',
            "Device Class" => $device['deviceClass'] ?? 'N/A',
            "Device With You" => $DeviceWithYou,
            "Is Locating" => $IsLocating,
            "Tracking Info" => $device['trackingInfo'] ?? 'N/A',
            // Agregando datos de $contentmore
            "Serial Number" => $serialNumber,
            "IMEI" => $imei,
            "Latest Backup" => $latestBackup,
            "Model Large Photo URL" => $modelLargePhotoURL2x
        ];

        // Guardar la salida en un archivo JSON
        file_put_contents($dirAppleAccount . "/Devices/output_$index.json", json_encode($output, JSON_PRETTY_PRINT));
    }

    // Combinar todas las salidas en un archivo final
    $allOutputs = [];
    foreach (glob($dirAppleAccount . "/Devices/output_*.json") as $filename) {
        $jsonData = json_decode(file_get_contents($filename), true);
        if ($jsonData !== null) {
            $allOutputs[] = $jsonData;
        }
    }

    file_put_contents($dirAppleAccount . "/final_output.json", json_encode($allOutputs, JSON_PRETTY_PRINT));

    // Mostrar el resultado final
    header('Content-Type: application/json');
    echo file_get_contents($dirAppleAccount . "/final_output.json");
} else {
    // Si no se encuentran dispositivos, devolver un mensaje de error
    $output = [
        "Devices" => "Without Devices",
        "Status" => "200"
    ];
    header('Content-Type: application/json');
    echo json_encode($output, JSON_PRETTY_PRINT);
}
